#!/bin/bash
Check=(`sudo netstat -lntp|awk '/^tcp/{split($4,Port,":");split($7,Name,"/");print Name[length(Name)]":"Port[length(Port)]}'|egrep -v 'java|nrpe|snmp|perl|zabbix_agentd|zabbix_proxy|vsftpd|sshd|rsync|500*|rpcbind|systemd'|sort -u`)
if [ -z "$Check" ];then
        exit
else
        length=${#Check[@]}
fi

printf "{\n"
printf  "\t\"data\":["
for((i=0;i<$length;i++))
do
        Server=`echo ${Check[$i]}|cut -d: -f1`
        Port=`echo ${Check[$i]}|awk -F':' '{print $NF}'`
        printf "\n\t\t{"
        printf "\n\t\t\t\"{#SERVERNAME}\":\"$Server\","
        printf "\n\t\t\t\"{#PORT}\":\"$Port\"}"
        if [ $i -lt $(($length-1)) ];then
                printf ','
        fi
done
printf  "]}\n"
