#!/bin/bash
#Author: WYM

pid_name='zabbix_agentd'
os_version=`echo $(cat /etc/redhat-release |tr -cd 0-9)|head -c 1`
mysql_user='root'
mysql_pass=`cat /etc/save/mysql_root`
mysql_host='localhost'
mysql_sock='/var/lib/mysql/mysql.sock'

# 获取当前工作目录
workdir=$(cd $(dirname $0); pwd)

# 编译php7.2（主要作用是拿来运行监控mysql的脚本）
tar xf php-7.2.1.tar.gz
cd php-7.2.1
./configure --prefix=/usr/local/php72 --with-config-file-path=/usr/local/php72/etc --enable-fpm --with-fpm-user=yiyu --with-fpm-group=yiyu --enable-mysqlnd --with-mysqli=mysqlnd --with-pdo-mysql=mysqlnd --enable-mysqlnd-compression-support --with-iconv-dir --with-freetype-dir --with-png-dir --with-zlib --enable-xml --enable-bcmath --enable-sysvsem --enable-mbstring --with-gd --with-openssl --with-xmlrpc
make
make install
if [ $? == '0' ];then
    echo_green "PHP 7.2 安装成功！"
	cd ${workdir}
else
	echo_red "PHP 7.2 安装成功！"
	exit 1
fi

function echo_green(){
    echo -e "\033[32m$*\033[0m"
}

function echo_red(){
    echo -e "\033[31m$*\033[0m"
}

echo_green "查询有没有多余的/etc/init.d/zabbix_agentd"
if [ -f /usr/lib/systemd/system/zabbix-agent.service ];then
    rm -f /usr/lib/systemd/system/zabbix-agent.service
fi

if [ `pidof ${pid_name}|wc -l` == '1' ];then
    echo_red "存在${pid_name}进程,即将杀掉."
    kill -9 `ps -ef|grep ${pid_name}|grep -v grep|awk '{print $2}'|xargs` 
fi

echo ""
echo ""
echo_green "查看杀掉了进程没有"
echo_green "@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@"
netstat -tlunp
echo_green "@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@"
echo ""
echo ""

read -r -p "请看看上面的服务信息,看看zabbix_agentd是否已经杀死?:" is_zabbix_killed

case $is_zabbix_killed in
    [yY][eE][sS]|[yY])
        echo_green "是的,已经都杀光了"
        ;;

    [nN][oO]|[nN])
        echo_red "并没有,请重新执行脚本."
        exit 1
        ;;

    *)
        echo "Invalid input..."
        exit 1
        ;;
esac

echo_green "该系统版本是: ${os_version}"
echo_green "正在查看是否已经安装zabbix_agentd"
rpm -qa|grep 'zabbix-agent' > /dev/null 2>&1
if [ $? == '0' ];then
        rpm -qa|grep zabbix-|egrep -v '(zabbix-proxy|zabbix-server)'|xargs yum -y remove
fi

echo_green "正在本地安装zabbix_agentd"
if [ ${os_version} == '7' ];then
	yum -y localinstall zabbix-agent-4.0.50-1.el7.x86_64.rpm zabbix-get-4.0.50-1.el7.x86_64.rpm zabbix-sender-4.0.50-1.el7.x86_64.rpm
elif [ ${os_version} == '8' ];then
	yum -y localinstall zabbix-agent-4.0.50-1.el8.x86_64.rpm zabbix-agent-4.0.50-1.el8.x86_64.rpm zabbix-agent-4.0.50-1.el8.x86_64.rpm
fi
	

read -r -p "是否已经成功安装zabbix_agentd? [Y/n] " install_sure

case $install_sure in
    [yY][eE][sS]|[yY])
        echo_green "是的"
        ;;

    [nN][oO]|[nN])
        echo_red "并没有,请重新执行脚本."
        exit 1
        ;;

    *)
        echo "Invalid input..."
        exit 1
        ;;
esac

echo_green "正在创建所需要的目录并授权为zabbix.zabbix"
mkdir -pv /run/zabbix /data/log/zabbix

echo_green "现在开始配置zabbix_agentd.conf"
read -r -p "请输入zabbix_agentd的hostname:" zabbix_agentd_name

read -r -p "请输入zabbix_proxy的内网IP:" zabbix_proxy_ip

if [ -f /etc/zabbix/zabbix_agentd.conf ];then
    echo_red "存在旧的zabbix_agentd.conf配置文件,现在需要先删除掉."
    rm -f /etc/zabbix/zabbix_agentd.conf
fi

\cp -v zabbix_agentd.conf /etc/zabbix/

sed -i "s@zabbix-agentd-name@${zabbix_agentd_name}@g" /etc/zabbix/zabbix_agentd.conf

if [ $? == '0' ];then
    echo_green "zabbix_agentd.conf配置成功"
fi

echo_green "正在添加相关权限到/etc/sudoers文件里面"
echo "
zabbix  ALL=(root) NOPASSWD:ALL
yiyu ALL=(root) NOPASSWD:ALL
" >> /etc/sudoers

echo_green "正在添加hosts"
if ! grep 'zabbix_proxy.mysqlmaster.host' /etc/hosts > /dev/null 2>&1;then
    echo '# zabbix' >> /etc/hosts
    echo '127.0.0.1         zabbix_proxy.mysqlmaster.host' >> /etc/hosts
fi

if ! grep 'zabbix_proxy.connect.host' /etc/hosts > /dev/null 2>&1;then
    echo "${zabbix_proxy_ip}         zabbix_proxy.connect.host" >> /etc/hosts
fi

if ! grep 'zabbix_server.connect.host' /etc/hosts > /dev/null 2>&1;then
    echo '8.218.98.248    zabbix_server.connect.host' >> /etc/hosts
fi

echo_green "现在把监控脚本复制到/etc/zabbix下"
rm -rf /etc/zabbix/scripts
cp -Rv scripts /etc/zabbix/

echo_green "现在把userparameter的配置文件复制到/etc/zabbix下"
rm -rf /etc/zabbix/zabbix_agentd.d
cp -Rv zabbix_agentd.d /etc/zabbix

echo_green "复制nginx,php-fpm监控文件到/etc/nginx/conf.d/下面"
if [ -d /etc/nginx/conf.d ];then
    if [ -f /etc/nginx/conf.d/127.0.0.1.conf ];then
        mv /etc/nginx/conf.d/127.0.0.1.conf /etc/nginx/conf.d/127.0.0.1.conf_bak
	fi
	\cp 127.0.0.1.conf /etc/nginx/conf.d/
fi

pidof nginx > /dev/null 2>&1
if [ $? == '0' ];then
	nginx -s reload
fi

systemctl enable zabbix-agent.service
systemctl start zabbix-agent.service

sleep 3

ps -ef|grep zabbix_agent

rm -f /etc/zabbix/zabbix_agentd.conf.rpmnew
rm -f /etc/zabbix/zabbix_agentd.conf.rpmsave

echo_green "给相关目录授权"
chmod +x /usr/bin/who
chown -R zabbix.zabbix /etc/zabbix /run/zabbix /data/log/zabbix

local_innet_ip=`ip addr|grep inet|awk '{print $2}'|grep -v '127.0.0.1'|cut -d '/' -f 1`
zabbix_agent_hostname=`grep "^Hostname" /etc/zabbix/zabbix_agentd.conf | awk -F'=' '{print $2}'`

echo ""
echo ""
echo ""
echo_green "@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@"
echo_red "请查看/etc/zabbix/scripts下面的脚本，一些监控数据库的脚本需要修改账户密码和socket的"
echo ""
echo ""
echo_green "本机系统版本:          ${os_version}"
echo_green "本机内网IP是:          ${local_innet_ip}"
echo_green "zabbix的hostname是:    ${zabbix_agent_hostname}"
echo ""
echo ""
echo_green "接下来,你去zabbix后台添加机器,具体信息请看上面"
echo_green "@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@"
