#!/bin/bash
#Author: WYM

pid_name='zabbix_agentd'
os_version=`echo $(cat /etc/redhat-release |tr -cd 0-9)|head -c 1`
mysql_user='root'
mysql_pass=`cat /etc/save/mysql_root`
mysql_host='localhost'
mysql_sock='/var/lib/mysql/mysql.sock'

# 获取当前工作目录
workdir=$(cd $(dirname $0); pwd)

# 编译php7.2（主要作用是拿来运行监控mysql的脚本）
tar xf php-7.2.1.tar.gz
cd php-7.2.1
./configure --prefix=/usr/local/php72 --with-config-file-path=/usr/local/php72/etc --enable-fpm --with-fpm-user=yiyu --with-fpm-group=yiyu --enable-mysqlnd --with-mysqli=mysqlnd --with-pdo-mysql=mysqlnd --enable-mysqlnd-compression-support --with-iconv-dir --with-freetype-dir --with-png-dir --with-zlib --enable-xml --enable-bcmath --enable-sysvsem --enable-mbstring --with-gd --with-openssl --with-xmlrpc
make
make install
if [ $? == '0' ];then
    echo_green "PHP 7.2 install success！"
	cd ${workdir}
else
	echo_red "PHP 7.2 install fail！"
	exit 1
fi

function echo_green(){
    echo -e "\033[32m$*\033[0m"
}

function echo_red(){
    echo -e "\033[31m$*\033[0m"
}

echo_green "Inquire if there is any extra /etc/init.d/zabbix_agent process!"
if [ -f /usr/lib/systemd/system/zabbix-agent.service ];then
    rm -f /usr/lib/systemd/system/zabbix-agent.service
fi

if [ `pidof ${pid_name}|wc -l` == '1' ];then
    echo_red "There is a ${pid_name} process that is about to be killed."
    kill -9 `ps -ef|grep ${pid_name}|grep -v grep|awk '{print $2}'|xargs` 
fi

echo ""
echo ""
echo_green "Did you kill the process????????"
echo_green "@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@"
netstat -tlunp
echo_green "@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@"
echo ""
echo ""

read -r -p "Please take a look at the service information above and see if Zabbix_agent has been killed?:" is_zabbix_killed

case $is_zabbix_killed in
    [yY][eE][sS]|[yY])
        echo_green "Yes, they have all been killed"
        ;;

    [nN][oO]|[nN])
        echo_red "No, please re execute the script."
        exit 1
        ;;

    *)
        echo "Invalid input..."
        exit 1
        ;;
esac

echo_green "The system version is: ${os_version}"
echo_green "Checking if zabbix_agentd has been installed??"
rpm -qa|grep 'zabbix-agent' > /dev/null 2>&1
if [ $? == '0' ];then
        rpm -qa|grep zabbix-|egrep -v '(zabbix-proxy|zabbix-server)'|xargs yum -y remove
fi

echo_green "Installing Zabbix_agent locally"
if [ ${os_version} == '7' ];then
	yum -y localinstall zabbix-agent-4.0.50-1.el7.x86_64.rpm zabbix-get-4.0.50-1.el7.x86_64.rpm zabbix-sender-4.0.50-1.el7.x86_64.rpm
elif [ ${os_version} == '8' ];then
	yum -y localinstall zabbix-agent-4.0.50-1.el8.x86_64.rpm zabbix-agent-4.0.50-1.el8.x86_64.rpm zabbix-agent-4.0.50-1.el8.x86_64.rpm
fi
	

read -r -p "Has Zabbix_agent been successfully installed? [Y/n] " install_sure

case $install_sure in
    [yY][eE][sS]|[yY])
        echo_green "Yes!!!"
        ;;

    [nN][oO]|[nN])
        echo_red "No, please re execute the script."
        exit 1
        ;;

    *)
        echo "Invalid input..."
        exit 1
        ;;
esac

echo_green "Creating the required directory and authorizing it as zabbix.zabbix!"
mkdir -pv /run/zabbix /data/log/zabbix

echo_green "Now start configuring Zabbix_gentd.conf!"
read -r -p "Please enter the hostname of zabbix_agent:" zabbix_agentd_name

read -r -p "Please enter the internal IP address of zabbix_proxy:" zabbix_proxy_ip

if [ -f /etc/zabbix/zabbix_agentd.conf ];then
    echo_red "There is an old zabbix_gentd.conf configuration file that needs to be deleted first."
    rm -f /etc/zabbix/zabbix_agentd.conf
fi

\cp -v zabbix_agentd.conf /etc/zabbix/

sed -i "s@zabbix-agentd-name@${zabbix_agentd_name}@g" /etc/zabbix/zabbix_agentd.conf

if [ $? == '0' ];then
    echo_green "Zabbix_gentd.conf configuration successful"
fi

echo_green "Add relevant permissions to the /etc/sudoers file"
echo "
zabbix  ALL=(root) NOPASSWD:ALL
" >> /etc/sudoers

echo_green "Adding hosts"
if ! grep 'zabbix_proxy.mysqlmaster.host' /etc/hosts > /dev/null 2>&1;then
    echo '# zabbix' >> /etc/hosts
    echo '127.0.0.1         zabbix_proxy.mysqlmaster.host' >> /etc/hosts
fi

if ! grep 'zabbix_proxy.connect.host' /etc/hosts > /dev/null 2>&1;then
    echo "${zabbix_proxy_ip}         zabbix_proxy.connect.host" >> /etc/hosts
fi

if ! grep 'zabbix_server.connect.host' /etc/hosts > /dev/null 2>&1;then
    echo '8.218.98.248    zabbix_server.connect.host' >> /etc/hosts
fi

echo_green "Now copy the monitoring script to /etc/zabbix"
rm -rf /etc/zabbix/scripts
cp -Rv scripts /etc/zabbix/

echo_green "Now copy the userparameter configuration file to /etc/zabbix"
rm -rf /etc/zabbix/zabbix_agentd.d
cp -Rv zabbix_agentd.d /etc/zabbix

echo_green "Create nginx and php fpm monitoring files under /etc/nginx/conf.d/"
if [ -d /etc/nginx/conf.d ];then
    if [ -f /etc/nginx/conf.d/127.0.0.1.conf ];then
        mv /etc/nginx/conf.d/127.0.0.1.conf /etc/nginx/conf.d/127.0.0.1.conf_bak
	fi
	\cp 127.0.0.1.conf /etc/nginx/conf.d/
fi

pidof nginx > /dev/null 2>&1
if [ $? == '0' ];then
	nginx -s reload
fi

systemctl enable zabbix-agent.service
systemctl start zabbix-agent.service

sleep 3

ps -ef|grep zabbix_agent

rm -f /etc/zabbix/zabbix_agentd.conf.rpmnew
rm -f /etc/zabbix/zabbix_agentd.conf.rpmsave

echo_green "Authorize relevant directories!!!!"
chmod +x /usr/bin/who
chown -R zabbix.zabbix /etc/zabbix /run/zabbix /data/log/zabbix

local_innet_ip=`ip addr|grep inet|awk '{print $2}'|grep -v '127.0.0.1'|cut -d '/' -f 1`
zabbix_agent_hostname=`grep "^Hostname" /etc/zabbix/zabbix_agentd.conf | awk -F'=' '{print $2}'`

echo ""
echo ""
echo ""
echo_green "@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@"
echo_red "Please refer to the scripts under /etc/zabbix/scripts. Some scripts for monitoring databases require changing account passwords and sockets!"
echo ""
echo ""
echo_green "Machine system version:                                   ${os_version}"
echo_green "What is the internal IP address of this machine:          ${local_innet_ip}"
echo_green "What is the hostname of Zabbix:                           ${zabbix_agent_hostname}"
echo ""
echo ""
echo_green "Next, you can go to the Zabbix backend to add the machine. Please refer to the above for specific information."
echo_green "@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@"
