#!/bin/sh
#php-fpm status
case $1 in
    ping)                           #检测php-fpm进程是否存在
    result=`/usr/bin/curl -s http://127.0.0.1:5658/yiyu_php_ping`
    if [ ${result} == 'pong' ];then
        echo '1'
    else
        echo '0'
    fi
    ;;
    start_since)             #提取status中的start since数值
    /usr/bin/curl http://127.0.0.1:5658/php_status 2>/dev/null  | awk 'NR==4{print $3}'
    ;;
    conn)                     #提取status中的accepted conn数值
    /usr/bin/curl http://127.0.0.1:5658/php_status 2>/dev/null  | awk 'NR==5{print $3}'
    ;;
    listen_queue)         #提取status中的listen queue数值
    /usr/bin/curl http://127.0.0.1:5658/php_status 2>/dev/null  | awk 'NR==6{print $3}'
    ;;
     max_listen_queue)  #提取status中的max listen queue数值
    /usr/bin/curl http://127.0.0.1:5658/php_status 2>/dev/null  | awk 'NR==7{print $4}'
    ;;
    listen_queue_len)    #提取status中的listen queue len
    /usr/bin/curl http://127.0.0.1:5658/php_status 2>/dev/null  | awk 'NR==8{print $4}'
    ;;
    idle_processes)      #提取status中的idle processes数值
    /usr/bin/curl http://127.0.0.1:5658/php_status 2>/dev/null  | awk 'NR==9{print $3}'
    ;;
    active_processes)   #提取status中的active processes数值
    /usr/bin/curl http://127.0.0.1:5658/php_status 2>/dev/null  | awk 'NR==10{print $3}'
    ;;
     total_processes)    #提取status中的total processess数值
    /usr/bin/curl http://127.0.0.1:5658/php_status 2>/dev/null  | awk 'NR==11{print $3}'
    ;;
    max_active_processes)     #提取status中的max active processes数值
    /usr/bin/curl http://127.0.0.1:5658/php_status 2>/dev/null  | awk 'NR==12{print $4}'
    ;;
     max_children_reached)    #提取status中的max children reached数值
    /usr/bin/curl http://127.0.0.1:5658/php_status 2>/dev/null  | awk 'NR==13{print $4}'
    ;;
    slow_requests)   #提取status中的slow requests数值
    /usr/bin/curl http://127.0.0.1:5658/php_status 2>/dev/null  | awk 'NR==14{print $3}'  
    ;;
    *)
    echo "Usage: $0 {conn|listen_queue|max_listen_queue|listen_queue_len|idle_processes|active_processess|total_processes|max_active_processes|max_children_reached|slow_requests}"
    exit 1
    ;;
esac
