#!/usr/bin/env python
# -*- coding: utf-8 -*-
# @Time    : 2024/10/22 15:31
# @Author  : Austin Wong
# @Email   : wym2222@163.com

try:
    import json
except:
    import simplejson as json

import subprocess


def action_command(cmd=''):
    child = subprocess.Popen(cmd, shell=True, stdout=subprocess.PIPE, stderr=subprocess.PIPE)
    (stdoutput, stderror) = child.communicate()
    code = child.returncode
    return {
        'output': stdoutput.decode().strip(),
        'error': stderror.decode().strip(),
        'code': code
    }


if __name__ == "__main__":
    result = action_command(cmd='''cat /proc/diskstats |awk '{print $3}'|egrep 'sd|vd|hd'|egrep -v '[0-9]'|sort -u''')

    if result['output']:
        outputs = result['output'].split('\n')
        disks = []
        for disk in outputs:
            disks += [{'{#DISKONE}': disk}]
        print(json.dumps({'data': disks}, sort_keys=True, indent=4))
    else:
        print('discovery error')

