#!/usr/bin/python
# -*- coding: utf-8 -*-
# @Time    : 2018/7/6 9:45
# @Author  : Austin Wong
# @Email   : wangyiming@hugenstar.org

# 此脚本一定要跟check_domain_expire_new.py同一个目录
import os
import sys
import json

if __name__ == '__main__':
    if len(sys.argv) != 2:
        print('Example: python %s yundyx.com' % __file__)
        sys.exit()

    domain = sys.argv[1]

    data_file = os.path.join(os.path.split(os.path.realpath(__file__))[0], 'monitor.txt')

    if not os.path.isfile(data_file):
        print('data file is not exists.')
        sys.exit()

    with open(data_file, 'r') as f:
        data = f.readlines()
        for line in data:
            if '"data"' in line:
                info = json.loads(line)['data']
                for item in info:
                    if domain in item.values():
                        print(item['{#EXPIREDATE}'])
