#!/bin/bash
#Author: WYM

pid_name='zabbix_proxy'
os_version=`echo $(cat /etc/redhat-release |tr -cd 0-9)|head -c 1`
mysql_user='root'
mysql_pass='root@rfTP_Gm7asfoB~cvt334HA*tV3Na'
mysql_host='localhost'
mysql_sock='/var/lib/mysql/mysql.sock'

function echo_green(){
    echo -e "\033[32m$*\033[0m"
}

function echo_red(){
    echo -e "\033[31m$*\033[0m"
}

if [ `pidof ${pid_name}|wc -l` == '1' ];then
    echo_red "存在${pid_name}进程,即将杀掉."
    kill `ps -ef|grep ${pid_name}|grep -v grep|awk '{print $2}'|xargs` 
fi

echo_green "改系统版本是: ${os_version}"
rpm -qa|grep zabbix-release > /dev/null 2>&1
if [ $? != '0' ];then
    rpm -qa|grep zabbix-release|xargs yum -y remove
    echo_green "安装zabbix源"
    if [ "${os_version}" == '7' ];then
        rpm -Uvh zabbix-release-4.0-2.el7.noarch.rpm
    elif [ "${os_version}" == '6' ];then
        rpm -Uvh zabbix-release-4.0-2.el6.noarch.rpm
    else
        echo_red "你这个系统又不是Centos6,又不是Centos 7,麻烦确认一下是什么版本的系统,脚本退出了"
        exit 1
    fi
fi

echo_green "正在查看是否已经安装zabbix_proxy"
rpm -qa|grep 'zabbix-proxy' > /dev/null 2>&1
if [ $? == '0' ];then
    rpm -qa|grep zabbix-|egrep -v '(zabbix-agent|zabbix-server)'|xargs yum -y remove
fi

echo_green "查看有没有编译安装的zabbix_proxy"
if [ -f "/etc/rc.d/init.d/zabbix_proxy" ];then
	rm -vrf /usr/bin/zabbix
	chkconfig zabbix_proxy off
	rm -vf /etc/rc.d/init.d/zabbix_proxy
	rm -vf /etc/init.d/zabbix_proxy
fi

echo_green "正在本地安装zabbix_proxy"
if [ ${os_version} == '6' ];then
	yum -y localinstall zabbix-proxy-mysql-4.0.16-1.el6.x86_64.rpm zabbix-sender-4.0.16-1.el6.x86_64.rpm zabbix-get-4.0.16-1.el6.x86_64.rpm
elif [ ${os_version} == '7' ];then
	yum -y localinstall zabbix-proxy-mysql-4.0.16-1.el7.x86_64.rpm zabbix-sender-4.0.16-1.el7.x86_64.rpm zabbix-get-4.0.16-1.el7.x86_64.rpm
fi

read -r -p "是否已经成功安装zabbix_proxy? [Y/n] " install_sure

case $install_sure in
    [yY][eE][sS]|[yY])
        echo_green "是的"
        ;;

    [nN][oO]|[nN])
        echo_red "并没有,请重新执行脚本."
        exit 1
        ;;

    *)
        echo "Invalid input..."
        exit 1
        ;;
esac

echo_green "正在创建所需要的目录并授权为zabbix.zabbix"
mkdir -pv /data/log/zabbix /var/run/zabbix /var/run/zabbix /var/log/snmptrap /etc/zabbix/externalscripts /etc/zabbix/zabbix_proxy.d && chown -R zabbix.zabbix /data/log/zabbix /var/run/zabbix /var/run/zabbix /var/log/snmptrap /etc/zabbix/externalscripts /etc/zabbix/zabbix_proxy.d

echo_green "你是否已经确认安装了数据库?"
read -r -p "是否已经安装成功zabbix_proxy并且没有报错? [Y/n] " mysql_sure
case $mysql_sure in
    [yY][eE][sS]|[yY])
        echo_green "是的"
        ;;
    
    [nN][oO]|[nN])
        echo_red "没有"
        echo_red "并没有,请配置好mysql并启动授权好再执行脚本."
        exit 1
        ;;

    *)
        echo "Invalid input..."
        exit 1
        ;;
esac

mysql -V|grep '5.7' > /dev/null 2>&1
if [ $? == '0' ];then
    /usr/bin/mysql -e "set global validate_password_length=4;"
    /usr/bin/mysql -e "set global validate_password_policy=LOW;"
fi

echo_green "现在验证是否有安装mysql并且能够顺利连接"
/usr/bin/mysql -u${mysql_user} -p${mysql_pass} -h${mysql_host} -e "show databases;" > /dev/null 2>&1
if [ $? != '0' ];then
    echo_red "数据库连接不上!"
    echo_red "请配置好脚本开头的数据库连接信息再重新执行脚本."
    exit 1
fi

echo_green "现在创建zabbix_proxy数据库并把表结构导进去,并且把zabbix_proxy数据库授权为: user->zabbix, passwd->zabbix"
/usr/bin/mysql -u${mysql_user} -p${mysql_pass} -h${mysql_host} -e "create database zabbix_proxy;"
if [ $? == '0' ];then
    echo_green "创建数据库zabbix_proxy成功."
else
    echo_red "建数据库zabbix_proxy失败."
    exit 1
fi

if [ ${os_version} == '6' ];then
	/usr/bin/mysql -u${mysql_user} -p${mysql_pass} -h${mysql_host} -e "grant all privileges on zabbix_proxy.* to zabbix@127.0.0.1 identified by 'zabbix';flush privileges;"
elif [ ${os_version} == '7' ];then
	/usr/bin/mysql -e "grant all privileges on zabbix_proxy.* to zabbix@127.0.0.1 identified by 'zabbix';flush privileges;"
fi
if [ $? == '0' ];then
    echo_green "数据库zabbix_proxy授权成功."
else
    echo_red "据库zabbix_proxy授权失败."
    exit 1
fi

echo_green "导入数据库结构."
zcat /usr/share/doc/zabbix-proxy-mysql-4.0.16/schema.sql.gz | /usr/bin/mysql -uzabbix -pzabbix -h'127.0.0.1' zabbix_proxy
if [ $? == '0' ];then
    echo_green "数据库结构导入成功."
else
    echo_red "据库结构导入失败."
    exit 1
fi

echo_green "现在开始配置zabbix_proxy.conf"
read -r -p "请输入zabbix_proxy的hostname:" zabbix_proxy_name

if [ -f /etc/zabbix/zabbix_proxy.conf ];then
    echo_red "存在旧的zabbix_proxy.conf配置文件,现在需要先删除掉."
    rm -f /etc/zabbix/zabbix_proxy.conf
fi
cp -v zabbix_proxy.conf /etc/zabbix/

sed -i "s@zabbix-proxy-name@${zabbix_proxy_name}@g" /etc/zabbix/zabbix_proxy.conf
sed -i "s@mysql-socket-name@${mysql_sock}@g" /etc/zabbix/zabbix_proxy.conf

if [ $? == '0' ];then
    echo_green "zabbix_proxy.conf配置成功"
fi

echo_green "正在添加hosts"
echo "
# zabbix
127.0.0.1         zabbix_proxy.mysqlmaster.host
129.211.120.56    zabbix_server.connect.host
" >> /etc/hosts

if [ "${os_version}" == '6' ];then
    chkconfig zabbix-proxy on
    /etc/init.d/zabbix-proxy start
elif [ "${os_version}" == '7' ];then
    systemctl enable zabbix-proxy
    systemctl start zabbix-proxy
fi

sleep 3

ps -ef|grep zabbix_proxy
